<?php


// Chemin du dossier courant
$CURRENT_DIR = __DIR__ . DIRECTORY_SEPARATOR;

// Chemin des dépendances (à modifier par l'utilisateur)
//$VENDOR_DIR = $CURRENT_DIR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR;
$VENDOR_DIR = $CURRENT_DIR . 'vendor' . DIRECTORY_SEPARATOR;

// Charger le classLoader
include_once($CURRENT_DIR . 'SplClassLoader.php');

// instancier le classloader
$classloader = new SplClassLoader();
// Enregistrer le classloader
$classloader->register();
// Déclarer l'epsace de nom « wellpack »
$classloader->addNamespace('wellpack', $VENDOR_DIR . 'wellpack');

// Clé d'utilisation (à modifier par l'utilisateur)
$API_KEY = 'd5a8237f-0286-11e8-987b-000d3a2457dd';
// URL d'appel du service
$URL = 'https://preprod.wepak.wellpack.fr/smsenvoi.php';

$result = '';
$request = null;
$responseObject = null;
$error = null;

use wellpack\wepak\ServiceRequest;

/**
 * @var \wellpack\wepak\WepackService
 */
$service = new \wellpack\wepak\WepackService($API_KEY, $URL);


if (isset($_GET['volume'])) { // Création d'une requête de volume
    
    /**
     * @var \wellpack\wepak\VolumeRequest
     */
    $request = new \wellpack\wepak\VolumeRequest();
    $request->setCodePostal(92120);
   //$request->setDept(75);
   // $request->setCivilite(\wellpack\wepak\ServiceRequest::CIVILITE_HOMME);
   // $request->setAgemin(30);
   // $request->setAgemax(45);
    
    /**
     * @var \wellpack\wepak\VolumeResponse $response
     */
    $responseObject = $service->getVolume($request);

} else if (isset($_GET['sendTest'])) { // Envoi d'une requête de sendTest
    
    /**
     * @var \wellpack\wepak\SendTestRequest
     */
    $request = new \wellpack\wepak\SendTestRequest();
    $request->setNumeroCommercant('06xxxxxxx');
    $request->setContent('text du sms');
    $request->setSenderlabel('nom éméteur');
    
    /**
     * @var \wellpack\wepak\SendTestResponse
     */
    $responseObject = $service->getSendTest($request);
    
    if (!$responseObject->isSuccess()) {
        $error = $responseObject->getMessage();
    }
    
} else if (isset($_GET['localityGroup'])) {
    
    /**
     * @var \wellpack\wepak\LocalityGroupCalcRequest
     */
    $request = new \wellpack\wepak\LocalityGroupCalcRequest();
    $request->setQuantite(1);
    $request->setListeCpDept([
        [
            ServiceRequest::KEY_LABEL => '92120',
            ServiceRequest::KEY_CP => [92120],
            ServiceRequest::KEY_QUANTITE => 10000
        ]/*, [
            ServiceRequest::KEY_LABEL => '33000',
            ServiceRequest::KEY_CP => [33000, 33100, 33200],
            ServiceRequest::KEY_QUANTITE => 600
        ], [
            ServiceRequest::KEY_LABEL => '75',
            ServiceRequest::KEY_CP => [75, 92, 91],
            ServiceRequest::KEY_QUANTITE => 700
        ], [
            ServiceRequest::KEY_LABEL => '33',
            ServiceRequest::KEY_CP => [33, 40, 42],
            ServiceRequest::KEY_QUANTITE => 800
        ]*/
    ]);
    //$request->setCivilite(\wellpack\wepak\ServiceRequest::CIVILITE_HOMME);
    //$request->setAgemax('45');
    //$request->setAgemin('30');
    // "ci":"4"
    $request->setNumeroCommercant('06xxxxxxxx');
    //"doublon":"true"
    $request->setDataout('volume');
    $request->setRepoussoirTempId(70);

    /**
     * @var \wellpack\wepak\LocalityGroupCalcResponse
     */
    $responseObject = $service->getLocalityGroupCalc($request);
    
} else if (isset($_GET['volume_global'])) { // Envoi d'une requête de volume Global
	
	/**
	 * @var \wellpack\wepak\VolumeGlobalRequest
	 */
	$request = new \wellpack\wepak\VolumeGlobalRequest();
	
	/**
	 * @var \wellpack\wepak\VolumeGlobalResponse $response
	 */
	$responseObject = $service->getVolumeGlobal($request);
	
} else if (isset($_GET['send'])) { // Envoi d'une requète de send
	
	/**
	 * @var \wellpack\wepak\SendRequest
	 */
	$request = new \wellpack\wepak\SendRequest();
	$request->setQuantite(1);
	$request->setCodePostal('92120');
	//$request->setDept('75,33');
	//$request->setCivilite(\wellpack\wepak\ServiceRequest::CIVILITE_HOMME);
	//$request->setAgemin(30);
	//$request->setAgemax(45);
	$request->setNumeroCommercant('06xxxxxxxx');
	$request->setContent('text du sms');
	$request->setSenderlabel('nom emeteur');
	$request->setSendDate('2050-12-31');
	$request->setTimeSend('19:00:00');
	$request->setImmediateSend(false);
	$request->setNumPartner('0612345678, 0623456789');
	
	/**
	 * @var \wellpack\wepak\SendResponse
	 */
	$responseObject = $service->getSend($request);
	
} else if (isset($_GET['listInterestGroup'])) { // Récupère la liste des groupes d'intérêts
	
	/**
	 * @var \wellpack\wepak\ListInterestGroupRequest
	 */
	$request = new \wellpack\wepak\ListInterestGroupRequest();
	$request->setIdInterestGroup(26);
	
	/**
	 * @var \wellpack\wepak\ListInterestGroupResponse
	 */
	$responseObject = $service->getListInterestGroup($request);
	
} else if (isset($_GET['listCiQualif'])) { // Récupère la liste des ci/qualif associé aux groupes d'intérêts
	
	/**
	 * @var \wellpack\wepak\GetInteretValueRequest
	 */
	$request = new \wellpack\wepak\GetInteretValueRequest();
	$request->setIdInterestGroup(26);
	
	/**
	 * @var \wellpack\wepak\GetInteretValueResponse
	 */
	$responseObject = $service->getInteretValue($request);

} else if (isset($_GET['createLienCourt'])) { // Création de lien court
	
	/**
	 * @var \wellpack\wepak\CreateLienCourtRequest
	 */
	$request = new \wellpack\wepak\CreateLienCourtRequest();
	$request->setKey(3);
	$request->setAdresseCible('http://wepak.fr');
	$request->setExtension('promo02');
	$request->setNomLienCourt('lien wellpack');
	
	/**
	 * @var \wellpack\wepak\CreateLienCourtResponse
	 */
	$responseObject = $service->getCreateLienCourt($request);
	
} else if (isset($_GET['listLienCourt'])) { // Lister les liens courts
	
	/**
	 * @var \wellpack\wepak\ListLienCourtRequest
	 */
	$request = new \wellpack\wepak\ListLienCourtRequest();
	$request->setKey(3);
	
	/**
	 * @var \wellpack\wepak\ListLienCourtResponse
	 */
	$responseObject = $service->getListLienCourt($request);
	
} else if (isset($_GET['supprLienCourt'])) { // Supprimer un lien court
	
	/**
	 * @var \wellpack\wepak\SupprLienCourtRequest
	 */
	$request = new \wellpack\wepak\SupprLienCourtRequest();
	$request->setKey(3);
	$request->setID(28396);
	
	/**
	 * @var \wellpack\wepak\SupprLienCourtResponse
	 */
	$responseObject = $service->getSupprLienCourt($request);
	
} else if (isset($_GET['save_repoussoir_temp'])) { // Création Repoussoir Temp
	
	/**
	 * @var \wellpack\wepak\CreateRepoussoirTempRequest
	 */
	$request = new \wellpack\wepak\CreateRepoussoirTempRequest();
    $request->setRepoussoirTempId(null);
    $request->setRepoussoirTempLabel('repoussoir_001');
    $request->setRepoussoirTempExterneId('D256');
    $request->setRepoussoirTempListe('29C80971B51D1D13DC7C41E79AC9BB77,29C80971B51D1D13DC7C41E79AC9BB77');
    
	
	/**
	 * @var \wellpack\wepak\CreateRepoussoirTempResponse
	 */
	$responseObject = $service->getCreateRepoussoirTemp($request);
	
}

if ($responseObject !== null) {
    if ($responseObject->isValid()) {
        $result = json_encode($responseObject, \JSON_PRETTY_PRINT);
    } else {
        $result = 'Erreur de la requête: ' . $responseObject->getErrorMessage();
    }
}

?>
<!DOCTYPE HTML>
<html>
    <head>
        <title>Test Wepak Service</title>
        <meta charset="utf-8">
        <style>
html, body {
    margin:0;
    padding:0;
    background: #fcfcfc;
    font: 100%/1.5 sans-serif;
}
h1 {
    color: #0A71B4;
}
h1, h2, h3 {
    margin: 1rem 0;
}
form, pre {
    margin: 0;
}
form {
    display: block;
    overflow: hidden;
    float: left;
    width: 25%;
    padding: 1.25em 0;
}
button {
    width: 100%;
    text-align: left;
}
article {
    float: right;
    width: 70%;
}
body > header,
main {
    max-width: 56em;
    margin: 0 auto; 
}
pre {
    border: 1px solid rgba(0,0,0,0.1);
    padding: 1rem;
    height: 10rem;
    background: #D6D7D9;
    white-space: pre-line;
    overflow: auto;
    margin-top: -1em;
}
        </style>
    </head>
    <body>
    	<header>
    		<h1>Test Wepak Service</h1>
    	</header>
        <main>

<form action="index.php">
	<button type="submit" name="volume_global" id="volume_global">01. volume_global</button>
    <button type="submit" name="volume" id="volume">02. volume</button>
	<button type="submit" name="send" id="send">03. send</button>	
    <button type="submit" name="sendTest" id="sendTest">04. send_test</button>
    <button type="submit" name="localityGroup" id="localityGroup">05. groupe de localite</button>
	<button type="submit" name="listInterestGroup" id="listInterestGroup">06. liste groupe d'interet</button>
	<button type="submit" name="listCiQualif" id="listCiQualif">07. liste ci/qualif</button>
	<button type="submit" name="createLienCourt" id="createLienCourt">08. create lien court</button>
	<button type="submit" name="listLienCourt" id="listLienCourt">09. list lien court</button>
	<button type="submit" name="supprLienCourt" id="supprLienCourt">10. supprimer lien court</button>
	<button type="submit" name="save_repoussoir_temp" id="save_repoussoir_temp">11. save repoussoir temp</button>
</form>
<article>
    <h2>Request</h2>
    <pre><?php echo json_encode($request, \JSON_PRETTY_PRINT); ?></pre>
    <h2>Response</h2>
    <?php if ($error !== null) {
        echo "<h3>Erreur</h3>"; 
        echo "<p>" . $error . "</p>";
    }?>
    <h3>Objet de réponse (json)</h3>
    <pre><?php echo $result; ?></pre>
    <h3>Objet de réponse (PHP)</h3>
    <pre><?php print_r($responseObject); ?></pre>
</article>
        </main>
    </body>
</html>