<?php

// Chemin du dossier courant
$CURRENT_DIR = __DIR__ . DIRECTORY_SEPARATOR;
// Chemin des dépendances
//$VENDOR_DIR = $CURRENT_DIR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR;
$VENDOR_DIR = $CURRENT_DIR . 'vendor' . DIRECTORY_SEPARATOR;

// Charger le classLoader
include_once($CURRENT_DIR . 'SplClassLoader.php');

// instancier le classloader
$classloader = new SplClassLoader();
// Enregistrer le classloader
$classloader->register();
// Déclarer l'epsace de nom « wellpack »
$classloader->addNamespace('wellpack', $VENDOR_DIR . 'wellpack');

// Clé d'utilisation
$API_KEY = 'd5a8237f-0286-11e8-987b-000d3a2457dd';

// URL d'appel du service
$URL = 'https://preprod.wepak.wellpack.fr/smsenvoi.php';

/**
 * @var \wellpack\wepak\WepackService
 */
$service = new \wellpack\wepak\WepackService($API_KEY, $URL);

use \wellpack\wepak\ServiceRequest as SevRequest;

$body = "";

$Html = '
<!DOCTYPE html>
<HTML>
    <head>
        <title>Test Wepak Service</title>
        <meta charset="utf-8">
        <style>
            div
            {
                margin:0;
                padding:0;
                background: #D6D7D9;
                font: 100%/1.5 sans-serif;
            }
        </style>
    </head>

<body>
<pre>
<code>
<div>
';

if (!isset($_GET['q'])) {
    return;
}

switch($_GET['q'])
{
    case 'volume_globale':
        
        /**
         * @var \wellpack\wepak\VolumeGlobalRequest
         */
        $request = new \wellpack\wepak\VolumeGlobalRequest();
        
        /**
         * @var \wellpack\wepak\VolumeGlobalResponse $response
         */
        $response = $service->getVolumeGlobal($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error,true));
            return;
        }
        
        // Valeur du volume global
        $value = $response->getVolumeGlobal();
        
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($value,true);
        break;
    case 'volume':
        /**
         * @var \wellpack\wepak\VolumeRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\VolumeRequest();
        
        $request->setCodePostal(92120);
        //$request->setDept(75);
        //$request->setCivilite(\wellpack\wepak\ServiceRequest::CIVILITE_HOMME);
        //$request->setAgemin(30);
        //$request->setAgemax(45);
        
        /**
         * @var \wellpack\wepak\VolumeResponse $response
         */
        $response = $service->getVolume($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error,true));
            return;
        }
        
        // Valeur du volume
        $value = $response->getVolume();
        
        $body .= "<pre> <code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response, \JSON_PRETTY_PRINT),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($value,true);
        $body .= "</code> </pre>";
        break;
    case 'send':
        /**
         * @var \wellpack\wepak\SendRequest
         */
        $request = new \wellpack\wepak\SendRequest();
        
        $request->setQuantite(1);
        $request->setCodePostal('92120');
        //$request->setDept('75,33');
        //$request->setCivilite(\wellpack\wepak\ServiceRequest::CIVILITE_HOMME);
        //$request->setAgemin(30);
        //$request->setAgemax(45);
        $request->setNumeroCommercant('06xxxxxxxx');
        $request->setContent('text du sms');
        $request->setSenderlabel('nom emeteur');
        $request->setSendDate('2050-12-31');
        $request->setTimeSend('19:00:00');
        $request->setImmediateSend(false);
        //$request->setNumPartner('0612345678, 0623456789');
        
        /**
         * @var \wellpack\wepak\SendResponse $response
         */
        $response = $service->getSend($request);
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message,true));
            return;
        }
        // Message retourné
        $message = $response->getMessage();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($message,true);
        break;
    case 'send_test':
        /**
         * @var \wellpack\wepak\SendTestRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\SendTestRequest();
        
        $request->setNumeroCommercant('06xxxxxxxx');
        $request->setContent('text du sms test');
        $request->setSenderlabel('éméteurtest');
        
        /**
         * @var \wellpack\wepak\SendTestResponse $response
         */
        $response = $service->getSendTest($request);
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message,true));
            return;
        }
        // Message retourné
        $message = $response->getMessage();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($message,true);
        break;
    case 'calcule_groupe_localite':
        /**
         * @var \wellpack\wepak\LocalityGroupCalcRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\LocalityGroupCalcRequest();
        
        $request->setQuantite(1);
        $request->setListeCpDept([
            [
                SevRequest::KEY_LABEL => '92120',
                SevRequest::KEY_CP => [92120],
                SevRequest::KEY_QUANTITE => 9000
            ]
        ]);
        //$request->setCivilite(SevRequest::CIVILITE_HOMME);
        //$request->setAgemax('45');
        //$request->setAgemin('30');
        // "ci":"4"
        //$request->setNumeroCommercant('06xxxxxxxx');
        //"doublon":"true"
        $request->setDataout('volume');
        
        /**
         * @var \wellpack\wepak\LocalityGroupCalcResponse $response
         */
        $response = $service->getLocalityGroupCalc($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error,true));
            return;
        }
        
        // Liste des localités
        $localities = $response->getLocalitiesData();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($localities,true);
        foreach($localities as $localite)
        {
            $body .= print_r("\r\n",true);
            $body .= print_r($localite->getType(),true);
            $body .= print_r("\r\n",true);
            $body .= print_r($localite->getLocalite(),true);
            $body .= print_r("\r\n",true);
            $body .= print_r($localite->getVolume(),true);
        }
        break;
    case 'liste_groupe_interet':
        /**
         * @var \wellpack\wepak\ListInterestGroupRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\ListInterestGroupRequest();
        
        $request->setIdInterestGroup('');
        
        /**
         * @var \wellpack\wepak\ListInterestGroupResponse $response
         */
        $response = $service->getListInterestGroup($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        // Liste des groupes dintérêt père/fils configurer sur le site web
        $list = $response->getListInterestGroup();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($list ,true);
        break;
    case 'liste_ci_qualif':
        /**
         * @var \wellpack\wepak\GetInteretValueRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\GetInteretValueRequest();
        
        $request->setIdInterestGroup(26);
        
        /**
         * @var \wellpack\wepak\GetInteretValueResponse $response
         */
        $response = $service->getInteretValue($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        // Liste des intérêts associés au groupe dintérêt.
        $list = $response->getInteretValueList();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($list ,true);
        break;
    case 'create_lien_court':
        /**
         * @var \wellpack\wepak\CreateLienCourtRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\CreateLienCourtRequest();
        
        $request->setKey(3);
        $request->setAdresseCible('http://wepak.fr');
        $request->setExtension('testfilipe2');
        $request->setNomLienCourt('lien testfilipe');
        
        /**
         * @var \wellpack\wepak\CreateLienCourtResponse $response
         */
        $response = $service->getCreateLienCourt($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message ,true));
            return;
        }
        
        $idLienCourt = $response->getIDLienCourt();
        $lienCourt = $response->getLienCourt();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($idLienCourt ,true); //28571
        $body .= print_r("\r\n" ,true);
        $body .= print_r($lienCourt ,true);
        break;
    case 'liste_lien_court':
        /**
         * @var \wellpack\wepak\ListLienCourtRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\ListLienCourtRequest();
        
        $request->setKey(3);
        
        /**
         * @var \wellpack\wepak\ListLienCourtResponse $response
         */
        $response = $service->getListLienCourt($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message ,true));
            return;
        }
        
        $liste = $response->getListLienCourt();
        
        $body .= '<pre><code>';
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($liste ,true);
        break;
    case 'suppression_lien_court':
        /**
         * @var \wellpack\wepak\SupprLienCourtRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\SupprLienCourtRequest();
        
        $request->setKey(3);
        $request->setID(28571);
        
        /**
         * @var \wellpack\wepak\SupprLienCourtResponse $response
         */
        $response = $service->getSupprLienCourt($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message ,true));
            return;
        }
        
        $message = $response->getMessage();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($message ,true);
        break;
    case 'save_repoussoir_temp':
        /**
         * @var \wellpack\wepak\CreateRepoussoirTempRequest
</code>
</pre>

         */
        $request = new \wellpack\wepak\CreateRepoussoirTempRequest();
        
        $request->setRepoussoirTempId('');
        $request->setRepoussoirTempLabel('repoussoir_001');
        $request->setRepoussoirTempExterneId('D256');
        $request->setRepoussoirTempListe('29C80971B51D1D13DC7C41E79AC9BB77,29C80971B51D1D13DC7C41E79AC9BB77');
        
        /**
         * @var \wellpack\wepak\CreateRepoussoirTempResponse $response
         */
        $response = $service->getCreateRepoussoirTemp($request);
        
        if (!$response->isValid()) {
            $error = $response->getErrorMessage();
            // Do something with message
            echo(print_r($error ,true));
            return;
        }
        
        if (!$response->isSuccess()) {
            $message = $response->getMessage();
            // Do something with message
            echo(print_r($message ,true));
            return;
        }
        
        $idLienCourt = $response->getIDLienCourt();
        $lienCourt = $response->getLienCourt();
        
        $body .= "<pre><code>";
        $body .= print_r($response,true);
        $body .= print_r("\r\n",true);
        $body .= print_r(json_encode($response),true);
        $body .= print_r("\r\n",true);
        $body .= print_r($idLienCourt ,true); //28571
        $body .= print_r("\r\n" ,true);
        $body .= print_r($lienCourt ,true);
        break;
}

//$body = str_replace("\r\n","</br>",$body);

$Html .= $body;

$Html .= '
</div>
</code>
</pre>
</body>
</html>
';

echo $Html;

?>