<?php
namespace wellpack\wepak;

class CreateLienCourtRequest extends ServiceRequest {
	
	// Requete pour créer un lien court
	
	// Type de requête envoyée au WebService
    const NAME = 'create_lien_court';

    public function getQueryName() 
    {
        return self::NAME;
    }
	
	 /**
     * identifiant de compte fournis par notre service technique.
     * @return string the $key
     */
    public function getKey()
    {
        return $this->get(self::KEY_KEY);
    }

	 /**
     * Adresse cible de la redirection exécutée par le lien court.
     * @return string the $adresseCible
     */	
    public function getAdresseCible()
    {
        return $this->get(self::KEY_ADRESSE_CIBLE);
    }

	 /**
     * Le domaine est sm-s.fr. Avec l'extension promo, nous obtenons un lien court = sm-s.fr/promo.
     * @return string Extension ajouter après le domaine du lien court.
     */	
    public function getExtension()
    {
        return $this->get(self::KEY_EXTENSION);
    }
	
	 /**
     * @return string Nom du lien court
     */	
    public function getNomLienCourt()
    {
        return $this->get(self::KEY_NOM_LIENCOURT);
    }
	
    /**
     * identifiant de compte fournis par notre service technique.
     * @param int $key
     */
    public function setKey($key)
    {
        $this->set(self::KEY_KEY, $key);
    }
	
    /**
     * Adresse cible de la redirection exécutée par le lien court.
     * @param string $adresseCible
     */
    public function setAdresseCible($adresseCible)
    {
        $this->set(self::KEY_ADRESSE_CIBLE, $adresseCible);
    }
	
    /**
     * Le domaine est sm-s.fr. Avec l'extension promo, nous obtenons un lien court = sm-s.fr/promo.
     * @param string $extension Extension ajoutée après le domaine du lien court.
     */
    public function setExtension($extension)
    {
        $this->set(self::KEY_EXTENSION, $extension);
    }
	
    /**
     * Définir le Nom du lien court
     * @param string $nomLienCourt Nom du lien court
     */
    public function setNomLienCourt($nomLienCourt)
    {
        $this->set(self::KEY_NOM_LIENCOURT, $nomLienCourt);
    }
    
}
