<?php
namespace wellpack\wepak;

class CreateRepoussoirTempRequest extends ServiceRequest {
	
	// Requete pour créer un lien court
	
	// Type de requête envoyée au WebService
    const NAME = 'save_repoussoir_temp';

    public function getQueryName() 
    {
        return self::NAME;
    }

	/**
	 * Id repoussoir temporaire, à passer dans le cas d'une modification de repoussoir temp.
	 * @return int the $repoussoirTempId
	 */	
	public function getRepoussoirTempId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_ID);
	}

		/**
	 * Label du repoussoir temporaire
	 * @return string label repoussoir temporaire.
	 */	
	public function getRepoussoirTempLabel()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_LABEL);
	}

	/**
	 * @return string Identifiant externe Repoussoir temp
	 */	
	public function getRepoussoirTempExterneId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_EXTENE_ID);
	}

	/**
	* @return string Liste des numero MD5 du Repoussoir temp
	*/	
	public function getRepoussoirTempListe()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_LISTE);
	}

	/**
	* @return string Prefixe du Repoussoir temp
	*/	
	public function getRepoussoirTempPrefixe()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_PREFIXE);
	}

	/**
	* @return string Type de hash (MD5/SHA2_256) du Repoussoir temp
	*/	
	public function getRepoussoirTempTypeHash()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_TYPE_HASH);
	}
	
	/**
	 * Id repoussoir temporaire, à passer dans le cas d'une modification de repoussoir temp.
	 * @param int the $Id
	 */	
	public function setRepoussoirTempId($Id)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_ID, $Id);
	}

	/**
	 * Label du repoussoir temporaire
	 * @param string label repoussoir temporaire.
	 */	
	public function setRepoussoirTempLabel($Label)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_LABEL, $Label);
	}

	/**
	 * @param string Identifiant externe Repoussoir temp
	 */	
	public function setRepoussoirTempExterneId($exteneId)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_EXTENE_ID, $exteneId);
	}

	/**
	 * @param string Liste des numero MD5 du Repoussoir temp
	*/	
	public function setRepoussoirTempListe($liste)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_LISTE, $liste);
	}

	/**
	 * @param string Prefixe du Repoussoir temp
	*/	
	public function setRepoussoirTempPrefixe($prefixe)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_PREFIXE, $prefixe);
	}

	/**
	 * @param string Prefixe du Repoussoir temp
	*/	
	public function setRepoussoirTempTypeHash($typehash)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_TYPE_HASH, $typehash);
	}
    
}
