<?php
namespace wellpack\wepak;

class GetInteretValueRequest extends ServiceRequest {
	
	// Requete pour récupérer la liste des ci/Qualif associée aux groupes d'intérêts
	
	// Type de requête envoyée au WebService
    const NAME = 'get_interet_value';

    public function getQueryName() 
    {
        return self::NAME;
    }
	
	 /**
     * @return string Numéro du groupe d'intérêt père. Permet de remonter les 
     * intérêt associée au groupe d'intérêt correspondant ou aux groupes 
     * d'intérêt fils correspondant.
     */
    public function getIdInterestGroup()
    {
        return $this->get(self::KEY_ID_INTEREST_GROUP);
    }
	
    /**
     * @param int $id_interest_group Numéro du groupe d'intérêt père. Permet de 
     * remonter les intérêt associée au groupe d'intérêt correspondant ou aux 
     * groupes d'intérêt fils correspondant..
     */
    public function setIdInterestGroup($id_interest_group)
    {
        $this->set(self::KEY_ID_INTEREST_GROUP, $id_interest_group);
    }
    
}
