<?php
namespace wellpack\wepak;

class ListInterestGroupRequest extends ServiceRequest {
	
	// Requete pour récupérer la liste des groupes d'intérêts
	
	// Type de requête envoyée au WebService
    const NAME = 'list_interest_group';

    public function getQueryName() {
        return self::NAME;
    }
	
	 /**
     * @return string Numéro du groupe d'intérêts père. permet de remonter les groupes d'intérêts fils.
     */
    public function getIdInterestGroup()
    {
        return $this->get(self::KEY_ID_INTEREST_GROUP);
    }
	
    /**
     * @param int $id_interest_group Numéro du groupe d'intérêts père. permet de remonter les groupes d'intérêts fils.
     */
    public function setIdInterestGroup($id_interest_group)
    {
        $this->set(self::KEY_ID_INTEREST_GROUP, $id_interest_group);
    }
}
