<?php

namespace wellpack\wepak;

class ListInterestGroupResponse extends ServiceResponse {
    
    private $parsedData = null;
    
    private function getParsedData()
    {
        if ($this->parsedData === null) {
            foreach ($this->data as $data) {
                $this->parsedData[] = new \wellpack\wepak\objects\InterestGroup($data);
            }
        }
        return $this->parsedData;
    }
    
    /**
     * Récupérer la liste des groupes d’intérêt père/fils configurer sur le site web
     * @param boolean $objectList Si vous souhaitez récupérer une liste d'objets
     * \wellpack\wepak\objects\InterestGroup. Sinon la méthode retourne une liste
     * de tableaux associatifs possédant les clés 'id_interest_group', 'label'
     * et 'description'.
     */
    public function getListInterestGroup($objectList=false)
    {
        return $objectList ? $this->getParsedData() : $this->data;
    }    
}
