<?php

namespace wellpack\wepak;

class LocalityGroupCalcRequest extends ServiceRequest {
    
    const OUTPUT_VOLUME = 'volume';
    const OUTPUT_TXT = 'txt';
    const OUTPUT_LIST = 'list';
    const OUTPUT_SEND = 'send';
    
    const NAME = 'calcule_groupe_localite';
    
    public function getQueryName() {
        return self::NAME;
    }
    
    /**
     * @return string Quantité
     */
    public function getQuantite()
    {
        return $this->get(self::KEY_QUANTITE);
    }

    /**
     * @return array
     */
    public function getListeCpDept()
    {
        return $this->get(self::KEY_LISTE_CP_DEPT);
    }

    /**
     * @return string $civilite
     */
    public function getCivilite()
    {
        return $this->get(self::KEY_CIVILITE);
    }

    /**
     * @return int $agemin
     */
    public function getAgemin()
    {
        return (integer) $this->get(self::KEY_AGEMIN);
    }

    /**
     * @return int $agemax
     */
    public function getAgemax()
    {
        return (integer) $this->get(self::KEY_AGEMAX);
    }

    /**
     * @return string $numero_commercant
     */
    public function getNumeroCommercant()
    {
        return $this->get(self::KEY_NUMERO_COMMERCANT);
    }

    /**
     * @return string $dataout
     */
    public function getDataout()
    {
        return $this->get(self::KEY_DATAOUT);
    }

    /**
     * @return string $id_application
     */
    public function getIdApplication()
    {
        return $this->get(self::KEY_ID_APPLICATION);
    }

    /**
     * @return string $repoussoir
     */
    public function getRepoussoir()
    {
        return $this->get(self::KEY_REPOUSSOIR);
    }

    /**
     * @return string $famille_qualif
     */
    public function getFamilleQualif()
    {
        return $this->get(self::KEY_FAMILLE_QUALIF);
    }

    /**
     * @return string $content
     */
    public function getContent()
    {
        return $this->get(self::KEY_CONTENT);
    }

    /**
     * @return string $senderlabel
     */
    public function getSenderlabel()
    {
        return $this->get(self::KEY_SENDERLABEL);
    }

    /**
     * @return string $senddate
     */
    public function getSenddate()
    {
        return $this->get(self::KEY_SENDATE);
    }

    /**
     * @return string $timesend
     */
    public function getTimesend()
    {
        return $this->get(self::KEY_TIMESEND);
    }

    /**
     * Si la campagne doit être envoyée immédiatement
     * @return boolean
     */
    public function isImmediatesend()
    {
        return $this->get(self::KEY_IMMEDIATESEND) === 'oui';
    }

    /**
     * @return string $idrouteur
     */
    public function getIdrouteur()
    {
        return $this->get(self::KEY_IDROUTEUR);
    }

    /**
     * @return string $idcampagne
     */
    public function getIdcampagne()
    {
        return $this->get(self::KEY_IDCAMPAGNE);
    }

    /**
     * @return string $num_partner
     */
    public function getNumPartner()
    {
        return $this->get(self::KEY_NUM_PARTNER);
    }

    /**
     * @return string $iris
     */
    public function getIris()
    {
        return $this->get(self::KEY_IRIS);
    }

	/**
	 * Id repoussoir temporaire.
	 * @return int the $repoussoirTempId
	 */	
	public function getRepoussoirTempId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_ID);
	}

    /**
     * @param int $quantite nombre de numéro à envoyer dans la campagne.
     */
    public function setQuantite($quantite)
    {
        if (is_numeric($quantite)) {
            $this->set(self::KEY_QUANTITE, $quantite);
        }
    }

    /**
     * @param array[] $liste_cp_dept Liste de 
     */
    public function setListeCpDept($liste_cp_dept)
    {
        // FIXME validate list_cp_dept
        $this->set(self::KEY_LISTE_CP_DEPT, $liste_cp_dept);
    }

    /**
     * Définir la civilité recherchée
     * @param string $civilite ServiceRequest::CIVILITE_HOMME || 
     *      ServiceRequest::CIVILITE_FEMME || ServiceRequest::CIVILITE_MIXTE
     */
    public function setCivilite($civilite)
    {
        if (RequestValidators::validateCivilite($civilite)) {
            $this->set(self::KEY_CIVILITE, $civilite);
        }
    }

    /**
     * Age minimum comprit entre 9 et 100
     * @param int $agemin
     */
    public function setAgemin($agemin)
    {
        if (RequestValidators::validateAgeNumber($agemin)) {
            $this->set(self::KEY_AGEMIN, $agemin);
        }
    }

    /**
     * Age minimum comprit entre 9 et 100
     * @param int $agemax
     */
    public function setAgemax($agemax)
    {
        if (RequestValidators::validateAgeNumber($agemax)) {
            $this->set(self::KEY_AGEMAX, $agemax);
        }
    }

    /**
     * @param string $numero_commercant
     */
    public function setNumeroCommercant($numero_commercant)
    {
        // FIXME Validate numéro
        $this->set(self::KEY_NUMERO_COMMERCANT, $numero_commercant);
    }

    /**
     * Définir le type de réponse de la requête
     * @param string $dataout (volume|txt|list|send)
     */
    public function setDataout($dataout)
    {
        $this->set(self::KEY_DATAOUT, $dataout);
    }

    /**
     * identifiant renvoyer par les applications permettant d’identifier les 
     * marques blanches ou les utilisateurs.
     * @param string $id_application
     */
    public function setIdApplication($id_application)
    {
        if (is_numeric($id_application)) {
            $this->set(self::KEY_ID_APPLICATION, $id_application);
        }
    }

    /**
     * @param int $repoussoir 0 (sans repoussoir) ou 1 (avec repoussoir)
     */
    public function setRepoussoir($repoussoir)
    {
        if (RequestValidators::validateRepoussoir($repoussoir)) {
            $this->set(self::KEY_REPOUSSOIR, $repoussoir);
        }
    }

    /**
     * Liste d'objet @link \wellpack\wepak\objects\CiQualif
     * @param array<\wellpack\wepak\objects\CiQualif> $famille_qualif
     */
    public function setFamilleQualif($famille_qualif)
    {
        // FIXME validate famille_qualif
        $this->set(self::KEY_FAMILLE_QUALIF, $famille_qualif);
    }

    /**
     * Le texte à envoyer dans la campagne.
     * @param string $content
     */
    public function setContent($content)
    {
        $this->set(self::KEY_CONTENT, $content);
    }

    /**
     * Libellé personnalisé de l'émetteur de la campagne.
     * @param string $senderlabel
     */
    public function setSenderlabel($senderlabel)
    {
        $this->set(self::KEY_SENDERLABEL, $senderlabel);
    }

    /**
     * Date d’envoi de la campagne. Si immediatesend est vrai alors 
     * ce paramètre peut être vide.
     * @param string $senddate Date au format YYYY-MM-JJ
     */
    public function setSenddate($senddate)
    {
        $this->set(self::KEY_SENDATE, $senddate);
    }

    /**
     * Heure d’envoi de la campagne. Si immediatesend est vrai alors ce paramètre 
     * peut être vide.
     * @param string $timesend Temps au format HH:MM:SS
     */
    public function setTimesend($timesend)
    {
        // validate time send
        $this->set(self::KEY_TIMESEND, $timesend);
    }

    /**
     * Si la campagne doit-être envoyée immédiatement
     * @param boolean $immediatesend true (oui) ou false (non)
     */
    public function setImmediatesend($immediatesend)
    {
        $this->set(self::KEY_IMMEDIATESEND, $immediatesend ? 'oui' : 'non');
    }

    /**
     * Identifiant du routeur qui doit envoyer la campagne fournis par le service technique.
     * @param int $idrouteur
     */
    public function setIdrouteur($idrouteur)
    {
            $this->set(self::KEY_IDROUTEUR, $idrouteur);
    }

    /**
     * identifiant de la campagne (ex. 145)
     * @param int $idcampagne
     */
    public function setIdcampagne($idcampagne)
    {
        $this->set(self::KEY_IDCAMPAGNE, $idcampagne);
    }

    /**
     * Liste de numéro de téléphone partenaire
     * @param string $num_partner Liste de numéros séparés par une virgule
     */
    public function setNumPartner($num_partner)
    {
        $this->set(self::KEY_NUM_PARTNER, $num_partner);
    }

    /**
     * liste de code iris séparés par une virgule
     * @param string $iris
     */
    public function setIris($iris)
    {
        $this->set(self::KEY_IRIS, $iris);
    }

	/**
	 * Id repoussoir temporaire.
	 * @param int the $Id
	 */	
	public function setRepoussoirTempId($Id)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_ID, $Id);
	}
    
    public function jsonSerialize()
    {
        $data = parent::jsonSerialize();
        if (isset($data[self::KEY_LISTE_CP_DEPT])) {
            $liste = $data[self::KEY_LISTE_CP_DEPT];
            foreach ($liste as &$item) {
                if (isset($item[self::KEY_CP]) && is_array($item[self::KEY_CP])) {
                    $item[self::KEY_CP] = implode(',', $item[self::KEY_CP]);
                }
                if (isset($item[self::KEY_DEPT]) && is_array($item[self::KEY_DEPT])) {
                    $item[self::KEY_DEPT] = implode(',', $item[self::KEY_DEPT]);
                }
            }
            $data[self::KEY_LISTE_CP_DEPT] = $liste;
        }
        return $data;
    }
}
