<?php

namespace wellpack\wepak;

use \wellpack\wepak\objects\LocalityData;

class LocalityGroupCalcResponse extends ServiceResponse {
    
    private $dataout = LocalityGroupCalcRequest::OUTPUT_VOLUME;
    
    public function __construct($response, $options = [])
    {
        parent::__construct($response, $options);
        $this->dataout = $options[ServiceRequest::KEY_DATAOUT];
        if ($this->data) {
            if ($this->dataout === LocalityGroupCalcRequest::OUTPUT_VOLUME) {
                $this->parseVolumeData();
            }
        }
    }
    
    /**
     * Récupérer la liste pour une requête avec dataout
     * LocalityGroupCalcRequest::OUTPUT_LIST. La méthode retourne null pour les
     * autres types de dataout.
     * @return array[]|NULL
     */
    public function getList()
    {
        if ($this->dataout === LocalityGroupCalcRequest::OUTPUT_LIST) {
            return $this->data;
        }
        return null;
        
    }
    
    /**
     * Récupérer la requête SQL pour une requête avec dataout
     * LocalityGroupCalcRequest::OUTPUT_TXT. La méthode retourne null pour les 
     * autres types de dataout.
     * @return string|NULL
     */
    public function getRequest()
    {
        if ($this->dataout === LocalityGroupCalcRequest::OUTPUT_TXT) {
            return $this->get('requete');
        }
        return null;
    }
    
    /**
     * Récupérer la liste des localités pour une requête avec dataout
     * LocalityGroupCalcRequest::OUTPUT_VOLUME. La méthode retourne null pour
     * les autres types de dataout.
     * @return \wellpack\wepak\objects\LocalityData[]|NULL
     */
    public function getLocalitiesData()
    {
        if ($this->dataout === LocalityGroupCalcRequest::OUTPUT_VOLUME) {
            return $this->data;
        }
        return null;
    }
    
    /**
     * Récupérer la reponse suite à l'envoi des localités pour une requête avec dataout
     * LocalityGroupCalcRequest::OUTPUT_SEND. La méthode retourne null pour
     * les autres types de dataout.
     * @return array[]|NULL
     */
    public function getSend()
    {
        if ($this->dataout === LocalityGroupCalcRequest::OUTPUT_SEND) {
            return $this->data;
        }
        return null;
    }
        
    private function parseVolumeData() 
    {
        $res = [];
        foreach ($this->data as $data) {
            $res[] = new LocalityData($data);
        }
        $this->data = $res;
    }
}
