<?php

namespace wellpack\wepak;

class RequestValidators {
    
    const RE_CODE_POSTAL = '/^[0-9]{5}$/';
    
    // date: YYYY-MM-JJ
    // time: HH:MM:SS
    
    public static function validateRepoussoir($repoussoir) {
        return $repoussoir === 0 || $repoussoir === 1;
    }
    
    public static function validateYesNo($value) {
        return $value === 'oui' || $value === 'non';
    }
    
    public static function validateCivilite(string $civilite) {
        return $civilite == ServiceRequest::CIVILITE_HOMME || 
            $civilite == ServiceRequest::CIVILITE_FEMME ||
            $civilite == ServiceRequest::CIVILITE_MIXTE;
    }
    
    public static function validateAgeNumber($num) {
        return is_integer($num) && $num > 9 && $num < 100;
    }
    
    public static function validateDept($dept) {
        return true;
//         if (is_array($dept)) {
//             foreach ($dept as $d) {
//                 if (!self::validateDept($d)) {
//                     return false;
//                 }
//             }
//             return true;
//         }
//         return ctype_digit($dept) && strlen($dept) === 2;
    }
    
    public static function validateCodePostal($code_postal) {
            return true;
//         if (is_array($code_postal)) {
//             foreach ($code_postal as $code) {
//                 if (!self::validateCodePostal($code)) {
//                     return false;
//                 }
//             }
//             return true;
//         }
//         return ctype_digit($code_postal) && strlen($code_postal) === 5;
    }
    
    
    private static function serializeArray($arr) {
        if (is_array($arr)) {
            return implode(',', $arr);
        }
        return (string) $arr;
    }
}
