<?php

namespace wellpack\wepak;
/**
 * Demande l’envoi d’une campagne correspondant aux valeurs des filtres.
 */
class SendRequest extends ServiceRequest {
	
	// Requete de send
	
	// Type de requête envoyée au WebService    
    const NAME = 'send';
    
    public function getQueryName() {
        return self::NAME;
    }
    
    /**
     * @return string Permet d'envoyer le sms au commerçant. Au format +33xxxxxxxxx ou 06xxxxxxxx (06 en exemple)
     */
    public function getNumeroCommercant()
    {
        return $this->get(self::KEY_NUMERO_COMMERCANT);
    }

    /**
     * @return string Contient le texte à envoyer dans la campagne
     */
    public function getContent()
    {
        return $this->get(self::KEY_CONTENT);
    }

    /**
     * @return string Libellé personnalisé de l'émetteur de la campagne
     */
    public function getSenderlabel()
    {
        return $this->get(self::KEY_SENDERLABEL);
    }

    /**
     * identifiant du routeur qui doit envoyer la campagne fournis par le service technique.
     * @return
     */
    public function getIdrouteur()
    {
        return $this->get(self::KEY_IDROUTEUR);
    }

    /**
     * identifiant de la campagne
     * @return
     */
    public function getIdcampagne()
    {
        return $this->get(self::KEY_IDCAMPAGNEL);
    }

    /**
     * identifiant renvoyer par les applications permettant d'identifier 
     * les marques blanches ou les utilisateurs. De type numérique.
     * @return
     */
    public function getIdApplication()
    {
        return $this->get(self::KEY_ID_APPLICATION);
    }

    /**
     * Date d'envoi de la campagne. Si immediatesend est vrai alors ce paramétre 
     * peut être vide.
     * @return
     */
    public function getSenddate()
    {
        return $this->get(self::KEY_SENDATE);
    }

    /**
     * Heure d'envoi de la campagne. Si immediatesend est vrai alors ce paramètre 
     * peut être vide.
     * @return
     */
    public function getTimesend()
    {
        return $this->get(self::KEY_TIMESEND);
    }
	
    /**
     * nombre de numéro à envoyer dans la campagne.
     * @return
     */
    public function getQuantite()
    {
        return $this->get(self::KEY_QUANTITE);
    }

    /**
     * Codes postaux sur 5 caracteres
     * @return string
     */
    public function getCodePostal()
    {
        return $this->get(self::KEY_CODE_POSTAL);
    }
	
    /**
     * Départements sur 2 caracteres en France métropolitaine.
     * @return
     */
    public function getDept()
    {
        return $this->get(self::KEY_DEPT);
    }

    /**
     * filtre sur le genre
     * @return
     */
    public function getCivilite()
    {
        return $this->get(self::KEY_CIVILITE);
    }
	
    /**
     * filtre sur l'âge minimum sur 2 caracteres minimum
     * @return
     */
    public function getAgemin()
    {
        return $this->get(self::KEY_AGEMIN);
    }

    /**
     * filtre sur l'âge maximum sur 2 caracteres minimum
     * @return
     */
    public function getAgemax()
    {
        return $this->get(self::KEY_AGEMAX);
    }
	
    /**
     * Repoussoir
     * @return
     */
    public function getRepoussoir()
    {
        return $this->get(self::KEY_REPOUSSOIR);
    }
	
    /**
     * Contient les ci et qualif correspondant à l'organisation par famille.
     * @return
     */
    public function getFamilleQualif()
    {
        return $this->get(self::KEY_FAMILLE_QUALIF);
    }
	
    /**
     * liste de numéro de téléphone partenaire
     * @return
     */
    public function getNumPartner()
    {
        return $this->get(self::KEY_NUM_PARTNER);
    }

    /**
     * liste de code iris
     * @return
     */
    public function getIris()
    {
        return $this->get(self::KEY_IRIS);
    }

	/**
	 * Id repoussoir temporaire.
	 * @return int the $repoussoirTempId
	 */	
	public function getRepoussoirTempId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_ID);
	}

    /**
     * @param string $numero_commercant sms au commerçant. Au format +33xxxxxxxxx ou 06xxxxxxxx (06 en exemple)
     */
    public function setNumeroCommercant($numero_commercant)
    {
        $this->set(self::KEY_NUMERO_COMMERCANT, $numero_commercant);
    }

    /**
     * @param string $content Texte à envoyer dans la campagne
     */
    public function setContent($content)
    {
        $this->set(self::KEY_CONTENT, $content);
    }

    /**
     * @param string $senderlabel Libellé personnalisé de l'émetteur de la campagne
     */
    public function setSenderlabel($senderlabel)
    {
        $this->set(self::KEY_SENDERLABEL, $senderlabel);
    }

    /**
     * identifiant du routeur qui doit envoyer la campagne fournis par le service technique.
     * @param int $idrouteur
     */
    public function setIdrouteur($idrouteur)
    {
        $this->set(self::KEY_IDROUTEUR, $idrouteur);
    }

    /**
     * identifiant de la campagne
     * @param int $idcampagne
     */
    public function setIdcampagne($idcampagne)
    {
        $this->set(self::KEY_IDCAMPAGNE, $idcampagne);
    }

    /**
     * identifiant renvoyer par les applications permettant d'identifier 
     * les marques blanches ou les utilisateurs. De type numérique.
     * @param int $id_application
     */
    public function setIdApplication($id_application)
    {
        $this->set(self::KEY_ID_APPLICATION, $id_application);
    }

    /**
     * Date d'envoi de la campagne. Si immediatesend = oui alors ce paramétre 
     * peut être vide.
     * @param string $senddate
     */
    public function setSenddate($senddate)
    {
        $this->set(self::KEY_SENDATE, $senddate);
    }

    /**
     * Heure d'envoi de la campagne. Si immediatesend = oui alors ce paramètre 
     * peut être vide.
     * @param string $timesend
     */
    public function setTimesend($timesend)
    {
        $this->set(self::KEY_TIMESEND, $timesend);
    }

    /**
     * Si la campagne doit être envoyée immédiatement
     * @return boolean
     */
    public function isImmediatesend()
    {
        return $this->get(self::KEY_IMMEDIATESEND) === 'oui';
    }
    
    /**
     * Si la campagne doit-être envoyée immédiatement
     * @param boolean $immediatesend true (oui) ou false (non)
     */
    public function setImmediatesend($immediatesend)
    {
        $this->set(self::KEY_IMMEDIATESEND, $immediatesend ? 'oui' : 'non');
    }
	
    /**
     * @param int $quantite nombre de numéro à envoyer dans la campagne.
     */
    public function setQuantite($quantite)
    {
        if (is_numeric($quantite)) {
            $this->set(self::KEY_QUANTITE, $quantite);
        }
    }

    /**
     * Code postal ou liste de codes postaux séparés par une virgule sur 5 chiffres.
     * @param string $codePostal
     */
    public function setCodePostal($codePostal)
    {
        $this->set(self::KEY_CODE_POSTAL, $codePostal);
    }
	
    /**
     * Départements sur 2 caracteres en France métropolitaine, 
     * séparés par une virgule.
     * @param string $dept 
     */
    public function setDept($dept)
    {
        $this->set(self::KEY_DEPT, $dept);
    }

    /**
     * filtre sur le genre
     * @param string $civilite ServiceRequest::CIVILITE_HOMME ou 
     * ServiceRequest::CIVILITE_FEMME ou ServiceRequest::CIVILITE_MIXTE
     */
    public function setCivilite($civilite)
    {
        if (RequestValidators::validateCivilite($civilite)) {
            $this->set(self::KEY_CIVILITE, $civilite);
        }
    }
	
    /**
     * filtre sur l'âge minimum sur 2 caracteres minimum
     * @param string $agemin
     */
    public function setAgemin($agemin)
    {
        if (RequestValidators::validateAgeNumber($agemin)) {
            $this->set(self::KEY_AGEMIN, $agemin);
        }
    }

    /**
     * filtre sur l'âge maximum sur 2 caracteres minimum
     * @param string $agemax
     */
    public function setAgemax($agemax)
    {
        if (RequestValidators::validateAgeNumber($agemax)) {
            $this->set(self::KEY_AGEMAX, $agemax);
        }
    }
	
    /**
     * Définir le repoussoir: 0 = sans repoussoir (valeur par défaut),
     * 1 = repoussoir.
     * @param string $repoussoir
     */
    public function setRepoussoir($repoussoir)
    {
        if (RequestValidators::validateRepoussoir($repoussoir)) {
            $this->set(self::KEY_REPOUSSOIR, $repoussoir);
        }
    }
	
    /**
     * Contient les ci et qualif correspondant à l'organisation par famille.
     * @param string $famille_qualif
     */
    public function setFamilleQualif($famille_qualif)
    {
        $this->set(self::KEY_FAMILLE_QUALIF, $famille_qualif);
    }
	
    /**
     * liste de numéro de téléphone partenaire
     * @param string $num_partner
     */
    public function setNumPartner($num_partner)
    {
        $this->set(self::KEY_NUM_PARTNER, $num_partner);
    }
	
    /**
     * liste de code iris séparés par une virgule
     * @param string $iris
     */
    public function setIris($iris)
    {
        $this->set(self::KEY_IRIS, $iris);
    }
	
	/**
	 * Id repoussoir temporaire.
	 * @param int the $Id
	 */	
	public function setRepoussoirTempId($Id)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_ID, $Id);
	}
}

