<?php

namespace wellpack\wepak;

class SendTestRequest extends ServiceRequest {
    
    const NAME = 'send_test';
    
    public function getQueryName() {
        return self::NAME;
    }
    
    /**
     * Numéro du commercant
     * @return string
     */
    public function getNumeroCommercant()
    {
        return $this->get(self::KEY_NUMERO_COMMERCANT);
    }

    /**
     * texte à envoyer dans la campagne
     * @return string
     */
    public function getContent()
    {
        return $this->get(self::KEY_CONTENT);
    }

    /**
     * Libellé personnalisé de l'émetteur de la campagne
     * @return string
     */
    public function getSenderlabel()
    {
        return $this->get(self::KEY_SENDERLABEL);
    }

    /**
     * Identifiant du routeur qui doit envoyer la campagne fournis par 
     * le service technique.
     * @return string
     */
    public function getIdrouteur()
    {
        return $this->get(self::KEY_IDROUTEUR);
    }

    /**
     * identifiant de la campagne
     * @return string
     */
    public function getIdcampagne()
    {
        return $this->get(self::KEY_IDCAMPAGNEL);
    }

    /**
     * Identifiant renvoyer par les applications permettant d’identifier 
     * les marques blanches ou les utilisateurs
     * @return string
     */
    public function getIdApplication()
    {
        return $this->get(self::KEY_ID_APPLICATION);
    }

    /**
     * Date d’envoi de la campagne. 
     * @return string
     */
    public function getSenddate()
    {
        return $this->get(self::KEY_SENDATE);
    }

    /**
     * Heure d’envoi de la campagne.
     * @return string
     */
    public function getTimesend()
    {
        return $this->get(self::KEY_TIMESEND);
    }

    /**
     * Si la campagne doit être envoyée immédiatement
     * @return boolean
     */
    public function isImmediatesend()
    {
        return $this->get(self::KEY_IMMEDIATESEND) === 'oui';
    }

    /**
     * Numéro du commercant 
     * @param string $numero_commercant Au format +33xxxxxxxxx ou 06xxxxxxxx
     */
    public function setNumeroCommercant($numero_commercant)
    {
        $this->set(self::KEY_NUMERO_COMMERCANT, $numero_commercant);
    }

    /**
     * texte à envoyer dans la campagne
     * @param string $content
     */
    public function setContent($content)
    {
        $this->set(self::KEY_CONTENT, $content);
    }

    /**
     * Libellé personnalisé de l'émetteur de la campagne
     * @param string $senderlabel
     */
    public function setSenderlabel($senderlabel)
    {
        $this->set(self::KEY_SENDERLABEL, $senderlabel);
    }

    /**
     * Identifiant du routeur qui doit envoyer la campagne fournis par 
     * le service technique.
     * @param string $idrouteur
     */
    public function setIdrouteur($idrouteur)
    {
        $this->set(self::KEY_IDROUTEUR, $idrouteur);
    }

    /**
     * identifiant de la campagne
     * @param string $idcampagne
     */
    public function setIdcampagne($idcampagne)
    {
        $this->set(self::KEY_IDCAMPAGNE, $idcampagne);
    }

    /**
     * Identifiant renvoyer par les applications permettant d’identifier 
     * les marques blanches ou les utilisateurs
     * @param string $id_application
     */
    public function setIdApplication($id_application)
    {
        $this->set(self::KEY_ID_APPLICATION, $id_application);
    }

    /**
     * Date d’envoi de la campagne. 
     * Si immediatesend = oui alors ce paramètre peut être vide.
     * @param string $senddate au format YYYY-MM-JJ
     */
    public function setSenddate($senddate)
    {
        $this->set(self::KEY_SENDATE, $senddate);
    }

    /**
     * Heure d’envoi de la campagne.
     * Si immediatesend = oui alors ce paramètre peut être vide.
     * @param string $timesend au format HH:MM:SS
     */
    public function setTimesend($timesend)
    {
        $this->set(self::KEY_TIMESEND, $timesend);
    }

    /**
     * Si la campagne doit-être envoyée immédiatement
     * @param boolean $immediatesend oui (true) ou non (false)
     */
    public function setImmediatesend($immediatesend)
    {
        $this->set(self::KEY_IMMEDIATESEND, $immediatesend ? 'oui' : 'non');
    }
}

