<?php

namespace wellpack\wepak;

use \wellpack\tools\MutableDataBag;

/**
 * Classe de requête à l'API wepak
 *
 */
abstract class ServiceRequest extends MutableDataBag {
    
    const CIVILITE_HOMME = 'homme';
    const CIVILITE_FEMME = 'femme';
    const CIVILITE_MIXTE = 'mixte';
    
    const KEY_QUERY = 'query';
    const KEY_CODE_POSTAL = 'code_postal';
    const KEY_CP = 'cp';
    const KEY_DEPT = 'dept';
    const KEY_CIVILITE = 'civilite';
    const KEY_AGEMIN = 'agemin';
    const KEY_AGEMAX = 'agemax';
    const KEY_ID_APPLICATION = 'id_application';
    const KEY_REPOUSSOIR = 'repoussoir';
    const KEY_FAMILLE_QUALIF = 'famille_qualif';
    const KEY_IRIS = 'iris';
    const KEY_LABEL = 'label';
    
    const KEY_NUMERO_COMMERCANT = 'numero_commercant';
    const KEY_CONTENT = 'content';
    const KEY_SENDERLABEL = 'senderlabel';
    const KEY_IDROUTEUR = 'idrouteur';
    const KEY_IDCAMPAGNE = 'idcampagne';
    const KEY_SENDATE = 'senddate';
    const KEY_TIMESEND = 'timesend';
    const KEY_IMMEDIATESEND = 'immediatesend';
    
    const KEY_QUANTITE = 'quantite';
    const KEY_LISTE_CP_DEPT = 'liste_cp_dept';
    const KEY_DATAOUT = 'dataout';
    const KEY_NUM_PARTNER = 'num_partner';
    
    const KEY_KEY = 'key';
    const KEY_ID = 'id';
    
    const KEY_ADRESSE_CIBLE = 'adresse_cible';
    const KEY_EXTENSION = 'extension';
    const KEY_NOM_LIENCOURT = 'nom_liencourt';
    
    const KEY_ID_INTEREST_GROUP = 'id_interest_group';
    
    const KEY_REPOUSSOIR_TEMP_ID = 'repoussoir_temp_id';
    const KEY_REPOUSSOIR_TEMP_LABEL = 'repoussoir_temp_label';
    const KEY_REPOUSSOIR_TEMP_EXTENE_ID = 'repoussoir_temp_externe_id';
    const KEY_REPOUSSOIR_TEMP_LISTE = 'repoussoir_temp_liste';
    const KEY_REPOUSSOIR_TEMP_PREFIXE = 'repoussoir_temp_prefixe';
    const KEY_REPOUSSOIR_TEMP_TYPE_HASH = 'repoussoir_temp_type_hash';
    
    /**
     * Retourne la valeur de la clé "request"
     */
    abstract function getQueryName();
    
    public function jsonSerialize() 
    {
        $data = parent::jsonSerialize();
        $data[self::KEY_QUERY] = $this->getQueryName();
        return $data;
    }
}
