<?php

namespace wellpack\wepak;

use \wellpack\tools\DataBag;

/**
 * Classe de réponse de l'API WEPAK
 *
 */
abstract class ServiceResponse extends DataBag {
    
    const KEY_ERROR = '__error__';
    const KEY_ID_MESSAGE = 'id_message';
    const KEY_MESSAGE = 'message';
    
    protected $options;
    
    /**
     * Construction de la réponse du service
     * @param string $response
     * @param array $options
     */
    public function __construct($response, $options = []) {
        parent::__construct(json_decode($response, true));
        $this->options = $options;
        // vérifier que la réponse de l'API est un erreur ou non.
        if (isset($this->data[self::KEY_ID_MESSAGE]) &&
                $this->data[self::KEY_ID_MESSAGE] === '1') {
            $this->data[self::KEY_ERROR] = $this->data[self::KEY_MESSAGE]; 
        }
    }
    
    /**
     * La requête effectuée a-t-elle retournée une réponse Valide ? Si non,
     * un message d'erreur est disponible via #getErrorMessage
     * 
     * @return boolean
     */
    public function isValid() {
        return $this->get(self::KEY_ERROR) !== null ? false : true;
    }
    
    /**
     * Récupérer le message d'erreur s'il y en a.
     * @return string
     */
    public function getErrorMessage() {
        return $this->get(self::KEY_ERROR, '');
    }
}
