<?php
namespace wellpack\wepak;

class SupprLienCourtRequest extends ServiceRequest {
	
	// Requete pour supprimer un lien court

	// Type de requête envoyée au WebService. Ici demande la suppression d'un lien court.
    const NAME = 'supprimer_lien_court';

    public function getQueryName() {
        return self::NAME;
    }
	
	 /**
     * @return string identifiant de compte fournis par le service technique.
     */
    public function getKey()
    {
        return $this->get(self::KEY_KEY);
    }

	 /**
     * @return string Id du lien court à supprimer. Récupérer avec la 
     * fonction qui permet de lister les liens courts.
     */	
    public function getID()
    {
        return $this->get(self::KEY_ID);
    }
	
    /**
     * identifiant de compte fournis par le service technique.
     * @param int $key
     */
    public function setKey($key)
    {
        $this->set(self::KEY_KEY, $key);
    }
	
    /**
     * Id du lien court à supprimer. Récupérer avec la 
     * fonction qui permet de lister les liens courts.
     * @param int $ID
     */
    public function setID($ID)
    {
        $this->set(self::KEY_ID, $ID);
    }
    
}
