<?php
namespace wellpack\wepak;

class UpdateRepoussoirTempPrefixeRequest extends ServiceRequest {
	
	// Requete pour créer un lien court
	
	// Type de requête envoyée au WebService
    const NAME = 'repoussoir_temp_save_prefixe';

    public function getQueryName() 
    {
        return self::NAME;
    }

	/**
	 * Id repoussoir temporaire, à passer dans le cas d'une modification de repoussoir temp.
	 * @return int the $repoussoirTempId
	 */	
	public function getRepoussoirTempId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_ID);
	}

	/**
	* @return string Prefixe du Repoussoir temp
	*/	
	public function getRepoussoirTempPrefixe()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_PREFIXE);
	}
	
	/**
	 * Id repoussoir temporaire, à passer dans le cas d'une modification de repoussoir temp.
	 * @param int the $Id
	 */	
	public function setRepoussoirTempId($Id)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_ID, $Id);
	}

	/**
	 * @param string Prefixe du Repoussoir temp
	*/	
	public function setRepoussoirTempPrefixe($prefixe)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_PREFIXE, $prefixe);
	}
    
}
