<?php

namespace wellpack\wepak;

/**
 * Requête pour la demande de volume.
 *
 */
class VolumeRequest extends ServiceRequest {

    const NAME = 'volume';

    public function getQueryName() {
        return self::NAME;
    }
    
    /**
     * Surchage de la méthode pour traiter les champs array
     * {@inheritDoc}
     * @see \wellpack\wepak\ServiceRequest::jsonSerialize()
     */
    public function jsonSerialize() {
        $data = parent::jsonSerialize();
        // traiter le code postal et dept
        if (isset($data[self::KEY_CODE_POSTAL]) && is_array($data[self::KEY_CODE_POSTAL])) {
            $data[self::KEY_CODE_POSTAL] = implode(',', $data[self::KEY_CODE_POSTAL]);
        }
        if (isset($data[self::KEY_DEPT]) && is_array($data[self::KEY_DEPT])) {
            $data[self::KEY_DEPT] = implode(',', $data[self::KEY_DEPT]);
        }
        return $data;
    }
    
    /**
     * Retourne le code postam
     * @return string
     */
    public function getCodePostal()
    {
        return $this->get(self::KEY_CODE_POSTAL);
    }

    /**
     * Retourne le département
     * @return string
     */
    public function getDept()
    {
        return $this->get(self::KEY_DEPT);
    }

    /**
     * Retourne la civilité
     * @return string
     */
    public function getCivilite()
    {
        return $this->get(self::KEY_CIVILITE);
    }

    /**
     * Retourne l'age minimum
     * @return
     */
    public function getAgemin()
    {
        return $this->get(self::KEY_AGEMIN);
    }

    /**
     * Retourne l'age maximum
     * @return
     */
    public function getAgemax()
    {
        return $this->get(self::KEY_AGEMAX);
    }

    /**
     * Retourne l'identifiant d'aplication
     * @return
     */
    public function getIdApplication()
    {
        return $this->get(self::KEY_ID_APPLICATION);
    }

    /**
     * @return
     */
    public function getRepoussoir()
    {
        return $this->get(self::KEY_REPOUSSOIR);
    }

    /**
     * @return
     */
    public function getFamilleQualif()
    {
        return $this->get(self::KEY_FAMILLE_QUALIF);
    }

    /**
     * @return
     */
    public function getIris()
    {
        return $this->get(self::KEY_IRIS);
    }

	/**
	 * Id repoussoir temporaire.
	 * @return int the $repoussoirTempId
	 */	
	public function getRepoussoirTempId()
	{
		return $this->get(self::KEY_REPOUSSOIR_TEMP_ID);
	}

    /**
     * filtre sur les code postaux sur 5 caractères.
     * 
     * @param int|int[] $code_postal
     */
    public function setCodePostal($code_postal)
    {
        if (RequestValidators::validateCodePostal($code_postal)) {
            $this->set(self::KEY_CODE_POSTAL, $code_postal);
        }
    }

    /**
     * @param string Le département
     */
    public function setDept($dept)
    {
        if (RequestValidators::validateDept($dept)) {
            $this->set(self::KEY_DEPT, $dept);
        }
    }

    /**
     * Définir la civilité recherchée
     * @param string $civilite ServiceRequest::CIVILITE_HOMME || 
     *      ServiceRequest::CIVILITE_FEMME || ServiceRequest::CIVILITE_MIXTE
     */
    public function setCivilite($civilite)
    {
        if (RequestValidators::validateCivilite($civilite)) {
            $this->set(self::KEY_CIVILITE, $civilite);
        }
    }

    /**
     * Age minimum comprit entre 9 et 100
     * @param int $agemin
     */
    public function setAgemin($agemin)
    {
        if (RequestValidators::validateAgeNumber($agemin)) {
            $this->set(self::KEY_AGEMIN, $agemin);
        }
    }

    /**
     * Age minimum comprit entre 9 et 100
     * @param int $agemax
     */
    public function setAgemax($agemax)
    {
        if (RequestValidators::validateAgeNumber($agemax)) {
            $this->set(self::KEY_AGEMAX, $agemax);
        }
    }

    /**
     * Identifiant de l'application
     * @param string $id_application
     */
    public function setIdApplication($id_application)
    {
        $this->set(self::KEY_ID_APPLICATION, $id_application);
    }

    /**
     * @param int $repoussoir 0 (sans repoussoir) ou 1 (avec repoussoir)
     */
    public function setRepoussoir($repoussoir)
    {
        if (RequestValidators::validateRepoussoir($repoussoir)) {
            $this->set(self::KEY_REPOUSSOIR, $repoussoir);
        }
    }

    /**
     * Les ci et qualif correspondant à l’organisation par famille.
     * 
     * @example [{"operateur":"AND","ci":[],"qualif":[72,73]},
     * {"operateur":"AND","ci":[19,55,56,57],"qualif":[]},
     * {"operateur":"AND","ci":[],"qualif":[83,123]}]
     *  
     * @param array $famille_qualif
     */
    public function setFamilleQualif($famille_qualif)
    {
        $this->set(self::KEY_FAMILLE_QUALIF, $famille_qualif);
    }

    /**
     * liste de code iris séparés par une virgule
     * @param string $iris
     */
    public function setIris($iris)
    {
        $this->set(self::KEY_IRIS, $iris);
    }

	/**
	 * Id repoussoir temporaire.
	 * @param int the $Id
	 */	
	public function setRepoussoirTempId($Id)
	{
		$this->set(self::KEY_REPOUSSOIR_TEMP_ID, $Id);
	}
}
