<?php

namespace wellpack\wepak\objects;

use wellpack\tools\DataBag;

/**
 * Objet de définition des ci et qualif correspondant à l’organisation par famille.
 */
class CiQualif extends DataBag {
    
    const KEY_OPERATEUR = 'operateur';
    const KEY_CI = 'ci';
    const KEY_QUALIF = 'qualif';
    
    /**
     * 
     * @param string $operator L'opérateur
     * @param array $ci Les ci
     * @param array $qualif Les qualifs
     */
    public function __construct($operator, $ci, $qualif) 
    {
        parent::__construct([
            self::KEY_OPERATEUR => $operator,
            self::KEY_CI => $ci,
            self::KEY_QUALIF => $qualif
        ]);
    }
}