<?php

namespace wellpack\wepak\objects;

use \wellpack\wepak\ServiceRequest;
use \wellpack\wepak\RequestValidators;
use wellpack\tools\MutableDataBag;

class CpDept extends MutableDataBag {
    
    public function getLabel()
    {
        return $this->get(ServiceRequest::KEY_LABEL);
    }
    
    public function setLabel($label)
    {
        $this->set(ServiceRequest::KEY_LABEL, $label);
    }
    
    /**
     * @return int|int[] [Le|les) code post(al|aux)
     */
    public function getCP()
    {
        return $this->get(ServiceRequest::KEY_CP);
    }
    
    /**
     * @param int|int[] $code_postal
     */
    public function setCP($cp)
    {
        if (RequestValidators::validateCodePostal($cp)) {
            $this->set(ServiceRequest::KEY_CP, $cp);
        }
    }
    
    /**
     * @param int|int[] $dept
     */
    public function setDept($dept)
    {
        if (RequestValidators::validateDept($dept)) {
            $this->set(ServiceRequest::KEY_DEPT, $dept);
        }
    }
    /**
     * @return string Le département
     */
    public function getDept()
    {
        return $this->get(ServiceRequest::KEY_DEPT);
    }
    
    
    public function getIris()
    {
        return $this->get(ServiceRequest::KEY_IRIS);
    }
    
    public function setIris($iris)
    {
        $this->set(ServiceRequest::KEY_IRIS, $iris);
    }
    
    public function jsonSerialize()
    {
        $data = parent::jsonSerialize();
        // traiter le code postal et dept
        if (isset($data[self::KEY_CODE_POSTAL]) && is_array($data[self::KEY_CODE_POSTAL])) {
            $data[self::KEY_CODE_POSTAL] = implode(',', $data[self::KEY_CODE_POSTAL]);
        }
        if (isset($data[self::KEY_DEPT]) && is_array($data[self::KEY_DEPT])) {
            $data[self::KEY_DEPT] = implode(',', $data[self::KEY_DEPT]);
        }
        return $data;
    }
}
