<?php

namespace wellpack\wepak\objects;

use \wellpack\tools\DataBag;

class LocalityData extends DataBag {
    
    const KEY_TYPE = 'Type';
    const KEY_LOCALITE = 'Localite';
    const KEY_VOLUME = 'Volume';
    /**
     * Récupérer le type de la localité (ex. "Dept")
     * @return string
     */
    public function getType() 
    {
        return $this->get(self::KEY_TYPE);
    }
    
    /**
     * Récupérer la localité (ex. "75")
     * @return string
     */
    public function getLocalite() 
    {
        return $this->get(self::KEY_LOCALITE);
    }
    
    /**
     * Récupérer le volume (ex. 12268)
     * @return string
     */
    public function getVolume() 
    {
        return $this->get(self::KEY_VOLUME);
    }
}